/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Id: netXTransport.cpp 6407 2014-06-23 10:36:22Z stephans $
   Last Modification:
    $Author: stephans $
    $Date: 2014-06-23 12:36:22 +0200 (Mo, 23 Jun 2014) $
    $Revision: 6407 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    Main module and entrypoint of the netXTransport DLL
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        xx
 
**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file netXTransport.cpp
/// Main module and entrypoint of the netXTransport DLL
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PhysicalInterface.h"

HMODULE g_hModule = NULL;
extern CRITICAL_SECTION g_tDriverOpenLock;

BOOL APIENTRY DllMain(HANDLE hModule, DWORD dwReason, LPVOID lpReserved)
{
  UNREFERENCED_PARAMETER( lpReserved);
	switch(dwReason)
	{
	case DLL_PROCESS_ATTACH:
    // Store our module handle
    g_hModule = (HMODULE)hModule;
    InitializeCriticalSection(&g_tDriverOpenLock);
    break;

	case DLL_PROCESS_DETACH:
    DeleteCriticalSection(&g_tDriverOpenLock);
		break;

	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
    break;

	}

  return TRUE;
}
